/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.mods.dsp.mixin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraftforge.fml.loading.FMLPaths;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import pro.mikey.mods.dsp.DSPInit;

@Mixin(value={DedicatedServerProperties.class})
public abstract class DedicatedServerPropertiesMixin {
    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/server/dedicated/DedicatedServerProperties;fromFile(Ljava/nio/file/Path;)Lnet/minecraft/server/dedicated/DedicatedServerProperties;"}, cancellable=true)
    private static DedicatedServerProperties fromFile(Path path, CallbackInfoReturnable<DedicatedServerProperties> info) {
        Path defaultSettingPath = FMLPaths.GAMEDIR.get().resolve("default-server.properties");
        if (!Files.exists(defaultSettingPath, new LinkOption[0])) {
            DSPInit.LOGGER.info("No default-server.properties exist in the games root path... ignoring default injection");
            return (DedicatedServerProperties)info.getReturnValue();
        }
        Path localMarkerFile = FMLPaths.GAMEDIR.get().resolve("local/default-used.marker");
        if (Files.exists(localMarkerFile, new LinkOption[0])) {
            DSPInit.LOGGER.info("Default server properties injection ignored as it has already been run. This is not an error. This is correct behaviour.");
            return (DedicatedServerProperties)info.getReturnValue();
        }
        if (Files.notExists(localMarkerFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(localMarkerFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                DSPInit.LOGGER.error("Failed to create local dir in the games root path...", (Throwable)e);
                return (DedicatedServerProperties)info.getReturnValue();
            }
        }
        try {
            Files.writeString(localMarkerFile, (CharSequence)"", new OpenOption[0]);
        }
        catch (IOException e) {
            DSPInit.LOGGER.error("Unable to create marker so avoiding default properties injection...", (Throwable)e);
            return (DedicatedServerProperties)info.getReturnValue();
        }
        DedicatedServerProperties dedicatedServerProperties = new DedicatedServerProperties(DedicatedServerProperties.m_139839_((Path)defaultSettingPath));
        System.out.println(dedicatedServerProperties.f_139741_);
        DSPInit.LOGGER.info("Replacing server properties with default properties!");
        info.setReturnValue((Object)dedicatedServerProperties);
        return dedicatedServerProperties;
    }
}

